/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Bool ray_hit    ; // if testing ray hit anything
Vec  ray_hit_pos; // if hit, then this is the hit position

Material *brick,
         *glass;
Mesh      mbox ,
          mball,
          mcapsule;

struct Object // object
{
   Actor actor; // actor
   Mesh *mesh ; // mesh

   void draw() // draw
   {
      if(mesh)mesh->draw(actor.matrix());
   }
};
Memb<Object> obj; // objects
/******************************************************************************/
void InitPre()
{
   App.name="Auto Depth of Field";
   App.flag=APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true).sync(true);
   ViewportFull.range=32;
   Ms.hide();

   // set initial depth of field parameters
   D.dof(DOF_HIGH,1, 1,0,6);
}
/******************************************************************************/
Bool Init()
{
   Physics.create();

   // get materials
   brick=Materials("../data/mtrl/brick/0.mtrl");
   glass=Materials("../data/mtrl/glass/0.mtrl");

   // shapes used for mesh and actor creation
   Box     box (32,1,32);
   Ball    ball(0.5);
   Capsule capsule(0.3,2);

   // create meshes
   mbox    .create(1).B(0).create(box    ,VTX_TX0|VTX_NRM|VTX_TNG).texScale(Vec2(16));
   mball   .create(1).B(0).create(ball   ,VTX_TX0|VTX_NRM|VTX_TNG);
   mcapsule.create(1).B(0).create(capsule,VTX_TX0|VTX_NRM|VTX_TNG);

   // set mesh materials, rendering versions and bounding boxes
   mbox    .setMaterial(brick).setRender().setBox();
   mball   .setMaterial(glass).setRender().setBox();
   mcapsule.setMaterial(brick).setRender().setBox();

   // create objects
   {
      // ground
      {
         Object &o=obj.New();
         o.mesh=&mbox;
         o.actor.create(box,0).pos(Vec(0,-box.h()/2,0));
      }

      // pillars
      REPD(x,16)
      REPD(z,16)
      {
         Object &o=obj.New();
         o.mesh=&mcapsule;
         o.actor.create(capsule,0).pos(Vec(box.lerpX(x/15.0),capsule.h/2-capsule.r,box.lerpZ(z/15.0)));
      }
      
      // balls
      REP(100)
      {
         Object &o=obj.New();
         o.mesh=&mball;
         o.actor.create(ball).pos(Vec(box.lerpX(RndF()),ball.r+capsule.h,box.lerpZ(RndF())));
      }
   }

   // set initial camera
   Cam.setAngle(Vec(0,2,0),0,-0.2).set();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   Physics.sim().get();

   // update camera
   {
      if(Kb.b(KB_A    ))Cam.matrix.pos-=Cam.matrix.x*Tm.d;
      if(Kb.b(KB_D    ))Cam.matrix.pos+=Cam.matrix.x*Tm.d;
      if(Kb.b(KB_W    ))Cam.matrix.pos+=Cam.matrix.z*Tm.d;
      if(Kb.b(KB_S    ))Cam.matrix.pos-=Cam.matrix.z*Tm.d;
      if(Kb.b(KB_SPACE))Cam.matrix.pos+=Cam.matrix.y*Tm.d;
      if(Kb.b(KB_LCTRL))Cam.matrix.pos-=Cam.matrix.y*Tm.d;
      if(Ms.hidden)
      {
         Cam.yaw  -=Ms.dir_d.x;
         Cam.pitch+=Ms.dir_d.y;
      }
      Cam.setAngle(Cam.matrix.pos,Cam.yaw,Cam.pitch).updateVelocities().set();
   }

   // toggle mouse
   if(Kb.bp(KB_TAB))Ms.toggle();

   // test ray
   {
      Flt     new_z; // new Z focus
      PhysHit phys_hit;
      Vec     pos,dir;

      if(Ms.hidden)
      {
         pos=Cam.matrix.pos;
         dir=Cam.matrix.z;
      }else
      {
         ScreenToPosDir(Ms.pos,pos,dir);
      }

      if(Physics.ray(pos,dir*Viewport.range,&phys_hit)) // cast a ray from camera and check if it hits something
      {
         ray_hit    =true;
         ray_hit_pos=phys_hit.plane.p;
         new_z      =phys_hit.dist; //set new z focus to ray hit distance
      }else
      {
         ray_hit=false;
         new_z  =Viewport.range; // set new z focus to viewport range
      }

      // set new depth of field z focus
      D.dofZ(LerpTime(D.dofZ(),new_z,0.001));
   }

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         REPAO(obj).draw();
      break;

      case RM_LIGHT:
         LightDir(1,!Vec(1,-1,1)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   if(ray_hit)Ball(0.1,ray_hit_pos).draw();
   D.text(0,0.9,"Press Tab to toggle mouse, WSAD+Space+Control to move camera");
}
/******************************************************************************/
